/**
* Script: updater.js
* Written by: Radnen
* Updated: 9/16/2010
**/

/**
* Updater Module:
*  - Allows for the easy use and growth of
*    constant updaters.
**/
function Updater()
{
	var actions = [];
	
	// Used to add an indexed function:
	this.addAction = function(key, func) {
		actions.push({key: key, func: func, paused: false});
	}
	
	// Used to remove indexed function(s):
	this.removeAction = function(key) {
		Utility.remove(this.actions, key, "key");
	}
	
	// Used to stop but not destroy an action:
	this.pauseAction = function(key) {
		actions[key].paused = true;
	}
	
	// Used to resume a previously paused action:
	this.resumeAction = function(key) {
		actions[key].paused = false;
	}
	
	// Updates all indexed functions:
	this.update = function() {
		for (var i in actions) { if (!actions[i].paused) actions[i].func(); }
	}
}